//
//  MCPSQLQualifier.h
//  MCFoundation
//
//  Created by Alykhan Jetha on Sun Aug 10 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BDQualifier.h"


/*!
	@class MCPSQLQualifier
	@discussion This object is intented to be a container of a RAW SQL where clause (anything that follows the 'WHERE'). Since you may not know the table aliases when coding this SQL, a mechanism has been provided to help you replace the unknown aliases with know ones at SQL generation time. For this to work, you must provide a comma separated 'entity order' and comma separated replacement order. The order must be exact. At SQL generation time, valid table aliases are gotten from the tableAliases object and a replace operation is performed.
	
	Example usage:
	
		sql_qual = [[[MCPSQLQualifier alloc] initWithSQL:@"-t2.contactID = -t3._rowid AND -t3.name like 'BOO%%'"
			group:@"-t3.name, -t3.category" 
			order:@"-t3.name ASC" 
			entityOrder:@"Contact, Role" 
			replacementOrder:@"-t2, -t3"] autorelease];
	
	
*/

@interface MCPSQLQualifier : BDQualifier 
{
	id				where;
	id				group;
	id				order;
	
	NSArray			*entityOrder;		// @"Contact, ContactTaskJoin, Task"
	NSArray			*replacementOrder;	// @"-t1, -t2, -t3"
}

- (id)initWithSQL:(id)sql group:(id)groupBySQL order:(id)orderBySQL 
	entityOrder:(NSString *)entity_order replacementOrder:(NSString *)replace_order;

- (NSString *)replace:(NSString *)orig with:(NSString *)new_alias inSQL:(id)sql;


@end
